<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Excel_model extends MY_Model{
	function __construct(){
		parent::__construct();
	}
	
	function gen($post){
		if(isset($post['DATA'])){
			$data = json_decode($post['DATA']);
			
			$this->load->library("excel");
			
			$this->excel->setActiveSheetIndex(0);	//Activate worksheet number 1
		
			//Cell Width---
			if(isset($data->WIDTH)){
				foreach($data->WIDTH as $location=>$v){
					$this->excel->getActiveSheet()->getColumnDimension($location)->setWidth(ceil($v / 7));
				}
			}
			//-------------
			
			//Font Size---
			if(isset($data->FONT_SIZE)){
				foreach($data->FONT_SIZE as $location=>$v){
					$this->excel->getActiveSheet()->getStyle($location)->getFont()->setSize($v);
				}
			}
			//------------
			
			//Font Weight---
			if(isset($data->FONT_WEIGHT)){
				foreach($data->FONT_WEIGHT as $location=>$v){
					if($v == "BOLD"){
						$this->excel->getActiveSheet()->getStyle($location)->getFont()->setBold(true);
					}
				}
			}
			//--------------
			
			if(isset($data->CONTENT)){
				foreach($data->CONTENT as $location=>$v){
					if(strpos($v, "<br>") !== FALSE){
						$v = str_replace("\n", "", $v);
						$v = str_replace("<br>", "\n", $v);
						$this->excel->getActiveSheet()->getStyle($location)->getAlignment()->setWrapText(true);
					}
					$this->excel->getActiveSheet()->setCellValue($location, $v);
				}
			}
			
			if(isset($data->MERGE)){
				foreach($data->MERGE as $v){
					$this->excel->getActiveSheet()->mergeCells($v);
				}
			}
			
			if(isset($data->H_ALIGN)){
				foreach($data->H_ALIGN as $location=>$v){
					$style = "";
					switch($v){
						case "C":
							$style = PHPExcel_Style_Alignment::HORIZONTAL_CENTER;
							break;
						case "L":
							$style = PHPExcel_Style_Alignment::HORIZONTAL_LEFT;
							break;
						case "R":
							$style = PHPExcel_Style_Alignment::HORIZONTAL_RIGHT;
							break;
					}
					if($style != "") $this->excel->getActiveSheet()->getStyle($location)->getAlignment()->setHorizontal($style);
				}
			}
			
			if(isset($data->V_ALIGN)){
				foreach($data->V_ALIGN as $location=>$v){
					$style = "";
					switch($v){
						case "M":
							$style = PHPExcel_Style_Alignment::VERTICAL_CENTER;
							break;
						case "T":
							$style = PHPExcel_Style_Alignment::VERTICAL_TOP;
							break;
						case "B":
							$style = PHPExcel_Style_Alignment::VERTICAL_BOTTOM;
							break;
					}
					if($style != "") $this->excel->getActiveSheet()->getStyle($location)->getAlignment()->setVertical($style);
				}
			}
			
			//Border---
			$index_array = array("T_BORDER", "B_BORDER", "L_BORDER", "R_BORDER");
			foreach($index_array as $border){
				if(isset($data->$border)){
					foreach($data->$border as $location=>$v){
						$style = "";
						switch($v){
							case "THIN":
								$style = PHPExcel_Style_Border::BORDER_THIN;
								break;
							case "THICK":
								$style = PHPExcel_Style_Border::BORDER_THICK;
								break;
							case "DOUBLE":
								$style = PHPExcel_Style_Border::BORDER_DOUBLE;
								break;
						}
						if($style != ""){
							switch($border){
								case "T_BORDER":
									$this->excel->getActiveSheet()->getStyle($location)->getBorders()->getTop()->setBorderStyle($style);
									break;
								case "B_BORDER":
									$this->excel->getActiveSheet()->getStyle($location)->getBorders()->getBottom()->setBorderStyle($style);
									break;
								case "L_BORDER":
									$this->excel->getActiveSheet()->getStyle($location)->getBorders()->getLeft()->setBorderStyle($style);
									break;
								case "R_BORDER":
									$this->excel->getActiveSheet()->getStyle($location)->getBorders()->getRight()->setBorderStyle($style);
									break;
							}
						}
					}
				}
			}
			//---------
			
			$this->excel->getActiveSheet()->setSelectedCells('A1');
			
			$filename = (isset($data->FILENAME)? $data->FILENAME:"Book1").".xlsx"; //File name
			header('Content-Type: application/vnd.ms-excel'); //mime type
			header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
			header('Cache-Control: max-age=0'); //no cache
			
			$objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel2007');
//			$objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
			$objWriter->save('php://output');
		}
	}
}