<?php $ci = get_instance();?>
<form onSubmit="return edit_validation(this);" action="<?php echo base_url($this->router->fetch_class()."/update")?>" method="POST" style="padding-left: 5px; padding-right: 5px;">
	<!--  -->
	<?php if(isset($data)):?>
		<input type="hidden" name="CODE" value="<?php echo $data->CODE;?>">
	<?php endif;?>
	<!--  -->
	
	<div class="form-group">
		<label><span style="color: red;">*</span> Gold Code</label>
		<div class="has-feedback">
			<input type="number" min="0" step="0.1" name="CODE" onInput="edit_check_unique();" value="<?php if(isset($data)) echo $ci->fm->str_esc($data->CODE, 2);?>" maxlength="10" class="form-control" required="required" autocomplete="OFF" <?php if(isset($data)) echo "readonly";?>>
			<span class="form-control-feedback" aria-hidden="true">
				<i class="fa fa-check check_unique_feedback_ok" style="display: none;"></i>
				<i class="fa fa-spinner fa-pulse check_unique_feedback_loading" style="display: none;"></i>
			</span>
		</div>
	</div>
	
	<div class="form-group">
		<label><span style="color: red;">*</span> Name</label>
		<input type="text" name="NAME" maxlength="60" value="<?php if(isset($data)) echo $ci->fm->str_esc($data->NAME, 2);?>" class="form-control" required="required" autocomplete="OFF">
	</div>

	<div class="form-group">
		<label><span style="color: red;"></span> Description</label>
		<input type="text" name="DESCRIPT" maxlength="50" value="<?php if(isset($data)) echo $ci->fm->str_esc($data->DESCRIPT, 2);?>" class="form-control" autocomplete="OFF">
	</div>

	<div class = "row">
		<div class="form-group col-md-4">
		    <div class="form-group ">
		        <label><span style="color: red;"></span> Category</label>
		            <select name="CATEGORY" id="CATEGORY" class="form-control select2">
	                    <option value="">--- Select a value ---</option>
	                    <?php foreach($all_category as $v):?>
	                        <option value="<?php echo $v->CODE;?>" <?php if(isset($data) && $data->CATEGORY == $v->CODE) echo "selected='selected'";?>>
	                        <?php echo "[".$v->CODE."] ".$v->DESCRIPT;?>
	                        </option>
	                    <?php endforeach;?>
	                </select>
		    </div>
		</div>
	    <div class="form-group col-md-4">
		    <div class="form-group">
		        <label><span style="color: red;"></span> Item Group</label>
		        <div class="has-feedback">
		            <select name="ITEM_GRP" id="ITEM_GRP" class="form-control select2">
	                    <option value="">--- Select a value ---</option>
	                    <?php foreach($all_item_grp as $v):?>
	                        <option value="<?php echo $v->CODE;?>" <?php if(isset($data) && $data->ITEM_GRP == $v->CODE) echo "selected='selected'";?>>
	                        <?php echo "[".$v->CODE."] ".$v->DESCRIPT;?>
	                        </option>
	                    <?php endforeach;?>
	                </select>
		        </div>
		    </div>
		</div>
		<div class="form-group col-md-4">
		    <div class="form-group ">
		        <label><span style="color: red;"></span> Taxcode</label>
		            <select name="TAXCODE" id="TAXCODE" class="form-control select2">
	                    <option value="">--- Select a value ---</option>
	                    <?php foreach($all_taxcode as $v):?>
	                        <option value="<?php echo $v->CODE;?>" <?php if(isset($data) && $data->TAXCODE == $v->CODE) echo "selected='selected'";?>>
	                        <?php echo "[".$v->CODE."] ".$v->DESCRIPTION;?>
	                        </option>
	                    <?php endforeach;?>
	                </select>
		    </div>
		</div>
	</div>

	<div class="form-group">
		<label><span style="color: red;"></span> Rate</label>
		<input type="number" step="0.0001" name="RATE" maxlength="60" value="<?php if(isset($data)) echo $ci->fm->str_esc($data->RATE, 2);?>" class="form-control" autocomplete="OFF">
	</div>

	<div class="form-group">
		<label><span style="color: red;"></span> Gold Stock</label>
		<input type="text" name="BAL" value="<?php if(isset($data)) echo $ci->fm->str_esc($data->BAL, 2);?>" class="form-control" autocomplete="OFF" readonly>
	</div>

	<?php if((! isset($data) && $can_create) || (isset($data) && $can_edit)):?>
		<div class="form-group" style="margin-top: 30px;">
			<label></label>
			<button type="submit" id="edit_btn_submit" class="btn btn-primary btn-xs-block btn_submit">
				<i class="fa fa-save"></i>
				Save
			</button>
		</div>
	<?php endif;?>
</form>

<script>
	$(document).ready(function(){
		$("#edit_ajax_container .select2").select2();

		<?php if(isset($data)):?>
			<?php if($can_delete):?>
				$(".btn_delete").show();
			<?php endif;?>

			<?php if($can_delete):?>
				$("#edit_div_action").show("fast");
			<?php endif;?>
			
			$("#delete_modal [name='CODE']").val("<?php echo $data->CODE;?>");
		<?php endif;?>

		<?php if(isset($data) && ! $can_edit):?>
			$("#edit_ajax_container input").prop("disabled", true);
			$("#edit_ajax_container select").prop("disabled", true);
			$("#edit_ajax_container textarea").prop("disabled", true);
		<?php endif;?>

	});

	function edit_check_unique(){
		var selector = "#edit_ajax_container [name='CODE']";
		$(selector).closest("div").removeClass("has-success");
		$(selector).closest("div").removeClass("has-error");
		$(selector).closest("div").find(".check_unique_feedback_ok").hide("fast");
		$(selector).closest("div").find(".check_unique_feedback_loading").show("fast");
		disable_btn("#edit_btn_submit");

		var unique = $(selector).val();
		checking_unique = unique;

		var params = "";
		params += "&unique=" + unique;
		<?php if(isset($data)):?>
			params += "&pk=" + $("#edit_ajax_container [name='CODE']").val();
		<?php endif;?>

		clearTimeout(timer_check_unique);
		timer_check_unique = setTimeout(function(){
			$.ajax({
				type: "POST",
				url: "<?php echo base_url($this->router->fetch_class());?>/check_unique",
				data: params,
				success: function(result, status, xhr){
					if(checking_unique == unique){
						if(result == "1"){
							$(selector).closest("div").addClass("has-success");
							$(selector).closest("div").find(".check_unique_feedback_ok").show("fast");
							enable_btn("#edit_btn_submit");
						}
						else{
							$(selector).closest("div").addClass("has-error");
						}
					}
				},
				error: function(xhr,status,error){
					if(checking_unique == unique){
					}
				},
				complete: function(xhr,status){
					if(checking_unique == unique){
						$(selector).closest("div").find(".check_unique_feedback_loading").hide("fast");
					}
				},
			});
		}, 500);
	}
	
	function edit_validation(form){
		var error = "";
		
		$(form).find("[required]:not(:disabled)").each(function(){
			if($(this).val() == ""){
				if(error != "") error += "<br>";
				switch($(this).attr("name")){
					case "USERNAME":
						error += "Please fill in the Username!";
						break;
					case "NAME":
						error += "Please fill in the Name!";
						break;
					case "GROUP_ID":
						error += "Please select a Group!";
						break;
					default:
						error += "Please complete the Form!";
						break;
				}
				
				return false;
			}
		});

		if(error == ""){
			disable_btn(".btn_submit");
		}
		else{
			prompt_error(error);
			return false;
		}
	}
</script>