<?php $ci = get_instance();?>
<!-- Error Modal -->
<div id="error_message_modal" class="modal fade" style="z-index: 9999;" tabindex="-1" role="dialog" aria-hidden="true">
	<div id="error_message_dialog" class="modal-dialog" style="width: 300px;">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button> 
				<h3 class="panel-title" style="color: #cb2a2a;"><i class="fa fa-exclamation-triangle"></i> Error</h3> 
			</div>
			<div class="modal-body"> 
				<p id="error_detail"></p>
			</div>
			<div class="modal-footer" style="">
				<a href="javascript:;" data-dismiss="modal" class="btn btn-default">Close</a>
			</div>
		</div>
	</div>
</div>
<!-- -->

<!-- Loading Modal -->
<div id="loading_modal" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog" style="width: 500px;">
		<div class="modal-content">
			<div class="modal-body">
				<center>
					<br><br>
					<i class="fa fa-spinner fa-pulse fa-5x"></i>
					<br>
					<span id="loading_description" style="font-weight: bold; font-size: 15px;"></span>
					<br><br>
					<br><br>
				</center>
			</div>
		</div>
	</div>
</div>
<!-- -->
	
<!-- input_assist_modal -->
<div id="input_assist_number_modal" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
	<div id="input_assist_modal_dialog" class="modal-dialog">
		<div class="modal-content">
			<form class="form-horizontal">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
					<h4 class="modal-title"><i class="fa fa-keyboard-o"></i> Virtual Keyboard</h4>
				</div>
				<div class="modal-body">
					<!--  -->
					<input type="hidden" id="input_assist_input">
					<!--  -->
					
					<table style="width: 100%; height: 80px; margin-bottom: 20px;">
						<tr>
							<td style="width: 100%; text-align: right; padding: 20px; border-radius: 5px; background-color: black; color: #1FF05A; font-size: 50px; font-weight: bold;">
								<span id="input_assist_indicator" style="font-family: 'Courier New', 'Lucida Console';"></span>
							</td>
						</tr>
					</table>
					<?php //input_assist_keyboard_special_chars?>
					<table id="input_assist_keyboard_1" style="width: 100%;">
						<?php for($x=0; $x<=7; $x++):?>
							<?php 
								$chars = "";
								switch($x){
									case 1:
										$chars = "1234567890";
										break;
									case 2:
										$chars = "QWERTYUIOP";
										break;
									case 3:
										$chars = "ASDFGHJKL";
										break;
									case 4:
										$chars = "ZXCVBNM";
										break;
									case 5:
										$chars = "!@#$%^&*()";
										break;
									case 6:
										$chars = ",.+-:;'\"/?";
										break;
									case 7:
										$chars = "~=<> -_\|";
										break;
								}
							?>
							<tr class="<?php if(in_array($x, array(5, 6, 7))) echo "input_assist_keyboard_special_chars";?>">
								<?php if($x == 3):?>
									<td></td>
								<?php elseif($x == 4):?>
									<td colspan="2" style="padding: 3px 5px;">
										<button type="button" onClick="input_assist_insert('SHIFT');" class="btn btn-default btn-block btn-lg btn_capslock">
											<i class="fa fa-arrow-up"></i>
										</button>
									</td>
								<?php endif;?>
								
								<?php if($x == 0):?>
									<?php for($y=1; $y<= 20; $y++):?>
										<td style="width: 5%;"></td>
									<?php endfor;?>
								<?php else:?>
									<?php foreach(str_split($chars) as $c):?>
										<td colspan="<?php echo $c != " "? "2":"4";?>" style="padding: 3px 5px;">
											<button type="button" onClick="input_assist_insert('<?php if(in_array($c, array("\"", "'", "\\"))) echo "\\";?><?php echo $c != "\""? $c:"x22";?>');" class="btn btn-default btn-block btn-lg">
												<?php echo $c != " "? $c:"Space";?>
											</button>
										</td>
									<?php endforeach;?>
								<?php endif;?>
								
								<?php if($x == 3):?>
									<td></td>
								<?php elseif($x == 4):?>
									<td colspan="4" style="padding: 3px 5px;">
										<button type="button" onClick="input_assist_insert('BS');" class="btn btn-default btn-block btn-lg">
											<i class="fa fa-times-circle"></i>
										</button>
									</td>
								<?php endif;?>
							</tr>
						<?php endfor;?>
					</table>
					
					<center>
						<table id="input_assist_keyboard_2" style="width: 300px;">
							<?php for($x=0; $x<=5; $x++):?>
								<?php 
									$chars = "";
									switch($x){
										case 1:
											$chars = "789";
											break;
										case 2:
											$chars = "456";
											break;
										case 3:
											$chars = "123";
											break;
										case 4:
											$chars = "B0C";
											break;
										case 5:
											$chars = ".+-";
											break;
									}
								?>
								<tr class="<?php if(in_array($x, array(5))) echo "input_assist_keyboard_special_chars";?>">
									<?php if($chars == ""):?>
										<?php for($y=1; $y<= 3; $y++):?>
											<td style="width: 33.33%;"></td>
										<?php endfor;?>
									<?php else:?>
										<?php foreach(str_split($chars) as $c):?>
											<?php 
												$input = $c;
												if($input == "B") $input = "BS";
												if($input == "C") $input = "CLEAR";
												if($input == ".") $input = "DOT";
												if($input == "+") $input = "POSITIVE";
												if($input == "-") $input = "NEGATIVE";
											?>
											<td style="padding: 3px 5px;">
												<button type="button" onClick="input_assist_insert('<?php echo $input;?>');" class="btn btn-default btn-block btn-lg <?php if(in_array($c, array("+", "-"))) echo "input_assist_btn_sign";?>">
													<?php if($input == "BS"):?>
														<i class="fa fa-arrow-left"></i>
													<?php else:?>
														<?php echo $c;?>
													<?php endif;?>
												</button>
											</td>
										<?php endforeach;?>
									<?php endif;?>
								</tr>
							<?php endfor;?>
						</table>
					</center>
				</div>
				<div class="modal-footer">
					<a href="javascript:;" data-dismiss="modal" class="btn btn-default">Cancel</a>
					<button type="button" onClick="input_assist_confirm();" data-dismiss="modal" class="btn btn-primary">
						<i class="fa fa-keyboard-o"></i>
						Confirm
					</button>
				</div>
			</form>
		</div>
	</div>
</div>
<!--  -->

<script>
	window.onunload = function(){};	//Allows Firefox to re-run script when page is back
	
	$(document).ready(function(){
		//Success Msg---
		prompt_success("<?php echo $this->session->flashdata('success');?>", <?php echo $this->session->flashdata('disable_success_auto_hide') != "1"? "null":"0";?>);
		//--------------
	
		//Error Msg---
		prompt_error("<?php echo $this->session->flashdata('error');?>");
	
		//	Hide Error Msg modal when press enter---
		$("#error_message_modal").keypress(function(e){
			if(e.which == 13){
				$("#error_message_modal").modal("hide");
			}
		});
		//	----------------------------------------
		//------------
		
		//Reason: To solve the opened modal unable to scroll when other modal is closed---
		$(".modal").on("hidden.bs.modal", function(){
			if($(".modal.in").length > 0) $("body").addClass("modal-open");
		});
		//--------------------------------------------------------------------------------
		
		//After Modal is opened, focus first element---
		$(".modal").on("shown.bs.modal", function(){
			focus_first_element(this);
		});
		//---------------------------------------------
	});
	
	//Global Variables---
	//-------------------
	
	//Success Message---
	function prompt_success(msg, hide_timer){
		if(hide_timer == undefined) hide_timer = 3000;
		
		if(msg != "" && msg != undefined){
			$("#p_success").html(msg);
			$("#div_success").show("1500");
	
			if(hide_timer > 0){
				setTimeout(function(){
					$("#div_success").hide("1500");
				}, hide_timer);
			}
		}
	}
	//------------------
	
	//Error Message---
	function prompt_error(msg, width){
		if(width == undefined) width = "300";
	
		if(msg != "" && msg != undefined){
			$("#error_message_dialog").css("width", width + "px");
			
			$("#error_detail").html(msg);
			$("#error_message_modal").modal("show");
		}
	}
	//----------------
	
	//Loading Modal---
	function prompt_loading(uncloseable, description){
		if(uncloseable == undefined) uncloseable = false;
		if(description == undefined) description = "Loading...";
	
		$("#loading_description").html(description);
		
		if(uncloseable){
			//Loading Modal which is unclosable---
		$("#loading_modal").modal({
			backdrop: 'static',
			keyboard: false
			});
			//------------------------------------
		}
		else{
		$("#loading_modal").modal("show");
		}
	}
	
	function dismiss_loading(){
		$("#loading_modal").modal("hide");
	}
	//----------------
	
	//Prompt Uncloseable Modal---
	function prompt_uncloseable_modal(modal){
		$(modal).modal({
			backdrop: 'static',
			keyboard: false
		});
	}
	//---------------------------
	
	//Log---
	function log(string){
		console.log(string);
	}
	//------
	
	//Disable/Enable BTN---
	var event_binding_storage = {};
	function disable_btn(selector){
		//Store binded event---
		if(event_binding_storage[selector] == undefined && ! $(selector).is(":disabled")){
			$(selector).each(function(x){
//				var events = $._data($(selector).get(0), "events");
				var events = $._data(this, "events");
				if(events != undefined && events.click != undefined){
					if(event_binding_storage[selector] == undefined) event_binding_storage[selector] = [];
					event_binding_storage[selector][x] = $.extend(true, {}, events.click);
				}
			});
			$(selector).unbind("click");
	
			$(selector).bind("click", function(e){
				e.preventDefault();
			});
		}
		//---------------------
	
		$(selector).attr("disabled", "disabled");
	}
	
	function enable_btn(selector){
		$(selector).removeAttr("disabled");
		$(selector).unbind("click");
	
		if(event_binding_storage[selector] != undefined){
			//Restore previously binded event---
			$(selector).each(function(x){
				var element = this;
				$.each(event_binding_storage[selector][x], function(){
					$(element).bind(this.type, this.handler);
				});
			});
			//----------------------------------
			
			event_binding_storage[selector] = null;
		}
	}
	//---------------------
	
	//Number only---
	function is_number(value, positive_only){
		if(positive_only == undefined) positive_only = false;
	
		if(positive_only){
			return (!isNaN(parseFloat(value)) && isFinite(value) && value>=0) || (value=="");
		}
		else{
			return (!isNaN(parseFloat(value)) && isFinite(value)) || (value=="") || (value=="-");
		}
	}
	
	function check_number_only(textbox, positive_only, no_decimal_place){
		if(positive_only == undefined) positive_only = true;
		if(no_decimal_place == undefined) no_decimal_place = false;
	
		var error = "";
	
		var value = $(textbox).val();
		if(is_number(value, positive_only)){
			if(no_decimal_place){
				if((to_float(value) - Math.floor(to_float(value))) != 0) error = "Please enter an Integer number!";
			}
		}
		else{
			if(positive_only){
				error = "Please enter a positive number!";
			}
			else{
				error = "Please enter a number!";
			}
		}
		
		if(error != ""){
			$(textbox).val("");
			$(":focus").blur();
			prompt_error(error, 300);
		}
	}
	//--------------
	
	//Number Input---
	function number_input(amount, element, restrict_number){
		//Default: Data >= 0
		if(restrict_number == undefined){
			restrict_number = amount > 0? null:0;
		}
		
		var data = parseInt($(element).val());
	
		if(! isNaN(data)){
			data += amount;
		}
		else{
			data = amount;
		}
	
		if(restrict_number != null){
			if(amount > 0){
				if(data > restrict_number) data = restrict_number;
			}
			else if(amount < 0){
				if(data < restrict_number) data = restrict_number;
			}
		}
	
		$(element).val(data);
		$(":focus").blur();
	}
	//---------------
	
	//Button Scrolling---
	function button_scrolling(element, direction, pixel){
		if(pixel == undefined) pixel = $(element).height();
	
		if(direction == "up"){
			$(element).animate({
				scrollTop: "-=" + pixel + "px",
			});
		}
		else if(direction == "down"){
			$(element).animate({
				scrollTop: "+=" + pixel + "px",
			});
		}
		else if(direction == "up_end"){
			$(element).animate({
				scrollTop: "-=" + 99999 + "px",
			});
		}
		else if(direction == "down_end"){
			$(element).animate({
				scrollTop: "+=" + 99999 + "px",
			});
		}
	
		$(":focus").blur();
	}
	//-------------------
	
	//Browser Print---
	function browser_print(element, css, hidden){
		if(hidden == null) hidden = false;
		
		var windowUrl = "about:blank";
		var uniqueName = new Date();
		var windowName = "Print" + uniqueName.getTime();

		if(! hidden){
			var width = screen.availWidth;
			var height = screen.availHeight;
			if(width > 15) width -= 15;
			if(height > 65) height -= 65;
			var left = 0;
			var top = 0;
		}
		else{
			var width = 100;
			var height = 100;
			var left = 5000;
			var top = 5000;
		}

		var printWindow = window.open(windowUrl, windowName, "left=" + left + ", top=" + top + ", width=" + width + ", height=" + height);

		if(!printWindow || printWindow.closed || typeof printWindow.closed=='undefined'){
			alert("Please enable pop-up from our site to enable print function.");
			return;
		}
		
		if(hidden){
			printWindow.resizeBy(-100, -100);
			printWindow.moveBy(1000, 1000);
		}

		var string = "";
		string += "<html>";
		string += 	"<head>";
		string += 		"<?php echo str_replace("\r\n", "", $this->load->view("includes/report_css", "", TRUE));?>";
		string += 		"<?php echo str_replace("\r\n", "", $this->load->view("includes/bill_css", "", TRUE));?>";
		if(css != undefined) string += 	"<style>" + css + "</style>";
		string += 	"</head>";
		string += 	"<body style='margin: 0px;'>";
		string += 		$(element).html();
		string += 	"</body>";
		string += "</html>";
		
		printWindow.document.write(string);
		printWindow.focus();

		setTimeout(function(){
			printWindow.print();
			printWindow.close();
		}, 1000);
	}
	//----------------
	
	//Print Fit---
	function print_fit(container, adj, height, retry_count){
		var standard_height = 880;	//Standard A4 / Letter
		
		var original_height = height;
		if(height == undefined){
			height = standard_height;
		}
		else if(height.toString().substr(0, 1) == "+"){
			height = standard_height + to_float(height.toString().substr(1));
		}
		else if(height.toString().substr(0, 1) == "-"){
			height = standard_height - to_float(height.toString().substr(1));
		}
	
		var current_height = to_float($(container).height());
		if(current_height > 0){
			var req_height = height - current_height;
	
			if(req_height > 0){
				$(adj).height(req_height);
			}
		}
		else{
			if(retry_count == undefined) retry_count = 1;
			
			if(retry_count < 100){
				setTimeout(function(){
					print_fit(container, adj, original_height, ++retry_count);
				}, 100);
			}
		}
	}
	//------------
	
	//Print Fit Row---
	function print_fit_row(container, row_container, content, height, retry_count){
		if(height == undefined) height = 880;	//Standard A4 / Letter
	
		if(content != undefined){
			var current_height = to_float($(container).height());
			if(current_height > 0){
				if(current_height <= height){
					$(row_container).append(content);
					
					print_fit_row(container, row_container, content, height, retry_count);
				}
				else{
					$(row_container).children().last().remove();
				}
			}
			else{
				if(retry_count == undefined) retry_count = 1;
				
				if(retry_count < 100){
					setTimeout(function(){
						print_fit_row(container, row_container, content, height, ++retry_count);
					}, 100);
				}
			}
		}
	}
	//------------
	
	//Date Format---
	function format_date(format, date_string){
		var string = "";
	
		if(date_string != undefined, date_string.length > 0){
			var date_obj = new Date(date_string);
	
			if(date_obj == "Invalid Date"){
				var year = date_string.substr(0, 4);
				var month = date_string.substr(5, 2);
				var day = date_string.substr(8, 2);
				var hour = date_string.substr(11, 2);
				var min = date_string.substr(14, 2);
				var sec = date_string.substr(17, 2);
	
				date_obj = new Date(year, to_int(month) - 1, day, hour, min, sec);
			}
			
			var month_array = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
			var day_array = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
	
			for(var x=0; x<format.length; x++){
				var c = format.charAt(x);
	
				switch(c){
					case "d":
						var date = date_obj.getDate();
						if(date.toString().length == 1) date = "0" + date;
						string += date;
						break;
					case "m":
						var month = date_obj.getMonth() + 1;
						if(month.toString().length == 1) month = "0" + month;
						string += month;
						break;
					case "M":
						string += month_array[date_obj.getMonth()];
						break;
					case "Y":
						string += date_obj.getFullYear();
						break;
					case "H":
						var hour = date_obj.getHours();
						if(hour.toString().length == 1) hour = "0" + hour;
						string += hour;
						break;
					case "h":
						var hour = date_obj.getHours();
						if(hour > 12) hour -= 12;
						if(hour.toString().length == 1) hour = "0" + hour;
						string += hour;
						break;
					case "i":
						var min = date_obj.getMinutes();
						if(min.toString().length == 1) min = "0" + min;
						string += min;
						break;
					case "s":
						var sec = date_obj.getSeconds();
						if(sec.toString().length == 1) sec = "0" + sec;
						string += sec;
						break;
					case "a":
						string += date_obj.getHours() < 12? "am":"pm";
						break;
					case "A":
						string += date_obj.getHours() < 12? "AM":"PM";
						break;
					case "D":
						string += day_array[date_obj.getDay()];
						break;
					default:
						string += c;
						break;
				}
			}
		}
		
		return string;
	}
	//--------------
	
	//Number Format---
	function number_format(target, decimal_place, comma){
		if(decimal_place == undefined) decimal_place = 2;
		if(comma == undefined) comma = true;
		target = target.toString();

		if(decimal_place != 10) target = number_format(target, 10, false);

		var dot_pos = target.indexOf(".");
		var target_before_decimal = dot_pos != -1? target.substring(0, dot_pos):target.substring(0);
		var target_after_decimal = dot_pos != -1? target.substring(dot_pos + 1):"";

		if(target_after_decimal.length > decimal_place){
			var rounding_digit = to_int(target_after_decimal.substr(decimal_place, 1));
			target_after_decimal = target_after_decimal.substr(0, decimal_place);
			if(rounding_digit >= 5){
				var original_length = target_after_decimal.length;
				target_after_decimal = (to_int(target_after_decimal) + 1).toString();
				while(target_after_decimal.length < original_length){
					target_after_decimal = "0" + target_after_decimal;
				}
				
				if(target_after_decimal.length > decimal_place){
					target_after_decimal = target_after_decimal.substr(1);

					target_before_decimal = to_int(target_before_decimal);
					target_before_decimal += target_before_decimal >= 0? 1:-1;
					target_before_decimal = target_before_decimal.toString();
				}
			}
		}
		
		while(target_after_decimal.length < decimal_place){
			target_after_decimal += "0";
		}

		if(comma) target_before_decimal = target_before_decimal.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
		
		var result = target_before_decimal;
		if(target_after_decimal != "") result += "." + target_after_decimal;

		return result;
	}
	//----------------
	
	//Checkbox Master---
	function checkbox_master(params){
		if(params.checkbox != undefined) var checkbox = params.checkbox;
		if(params.child_element != undefined) var child_element = params.child_element;
		if(params.enable_only != undefined) var enable_only = params.enable_only;
		if(params.mode != undefined) var mode = params.mode;
		if(params.trigger_change != undefined) var trigger_change = params.trigger_change;
	
		if(enable_only == undefined) enable_only = true;
		if(mode == undefined) mode = 1;
		if(trigger_change == undefined) trigger_change = false;
	
		if(checkbox != undefined && child_element != undefined){
			$(child_element).each(function(){
				if(! $(this).is(":disabled") || ! enable_only){
					switch(mode){
						case 1:
							$(this).prop("checked", $(checkbox).is(":checked"));
							break;
						case 2:
							$(this).bootstrapSwitch("state", $(checkbox).is(":checked"));
							break;
					}

					if(trigger_change) $(child_element).change();
				}
			});
		}
	}
	//------------------
	
	//Checkbox Limit---
	function checkbox_limit(checkbox, selector, limit, error_action){
		if(checkbox != undefined && selector != undefined && $(checkbox).is(":checked")){
			limit = limit != undefined? to_int(limit):1;
	
			var count = 1;
			$(selector).each(function(){
				if(this != checkbox && $(this).is(":checked")){
					count++;
	
					if(count > limit){
						if(limit == 1){
							$(this).prop("checked", false);
						}
						else{
							$(checkbox).prop("checked", false);
						}
						
						if(error_action != undefined) error_action();
						return false;
					}
				}
			});
		}
	}
	//-----------------
	
	//Resize Textarea---
	function resize_textarea(selector){
		if($(selector).length > 0){
			$(selector).each(function(){
				if($(this).outerHeight() < $(this)[0].scrollHeight){
					$(this).height($(this)[0].scrollHeight);
				}
			});
		}
	}
	//------------------
	
	//To Int---
	function to_int(number){
		if(number != undefined) number = number.toString().replace(/,/g, '');
		return (is_number(number) && !isNaN(parseInt(number)))? parseInt(number):0;
	}
	//-----------
	
	//To Float---
	function to_float(number){
		if(number != undefined) number = number.toString().replace(/,/g, '');
		return (is_number(number) && !isNaN(parseFloat(number)))? parseFloat(number):0;
	}
	//-----------
	
	//Next Character---
	function next_char(string){
		var result = string;
	
		var all_char = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
		if(string.length > 0){
			var c = string.slice(-1);	//Get last character
	
			var index = all_char.indexOf(c);
			if(index != -1){
				if(index != (all_char.length - 1)){
					result = string.substr(0, string.length - 1);
					
					result += all_char[index + 1];
				}
				else{
					if(string.substr(0, string.length - 1) == ""){
						result = "A";
					}
					else{
						result = next_char(string.substr(0, string.length - 1));
					}
					result += "A";
				}
			}
		}
	
		return result;
	}
	//-----------------
	
	//Data List Sort---
	function data_list_sort(th){
		var sort = $(th).attr("data-sort");
		if(sort != ""){
			$("#filter_form [name='S']").val(sort);
			
			var SD = 0;
			if($(th).find("i.fa-caret-down").length > 0){
				SD = 1;
			}
			$("#filter_form [name='SD']").val(SD);
			
			$("#filter_form").submit();
		}
	}
	//-----------------
	
	//Focus first element---
	function focus_first_element(selector){
		var element_array = $(selector).find("select:input:visible:enabled:first, input:input:visible:enabled:first");
		if(element_array.length > 0){
			element_array[0].focus();
	
			if($(element_array[0]).is("input:text")){
				$(element_array[0]).val($(element_array[0]).val());	//Move cursor to the end
			}
		}
	}
	//----------------------
	
	//page_onchange---
	function page_onchange(page){
		if($("#filter_form [name='PAGE']").length > 0){
			$("#filter_form [name='PAGE']").val(page);
			$("#filter_form").submit();
		}
	}
	//----------------
	
	//per_page_onchange---
	function per_page_onchange(selector){
		var per_page = to_int($(selector).val());
		if(per_page > 0 && $("#filter_form [name='PP']").length > 0){
			localStorage.<?php echo $ci->config->item('project');?>_per_page = per_page;
			
			$("#filter_form [name='PP']").val(per_page);
			$("#filter_form [name='PAGE']").val(1);
			$("#filter_form").submit();
		}
	}
	//--------------------
	
	//Crystal Report---
	function crystal_report(report){
		if(report != null && report.length > 0){
			$.ajax({
				type: "POST",
				url: "<?php echo base_url("cr");?>",
				data: "REPORT="+report,
				success: function(result, status, xhr){
					
				},
				error: function(xhr,status,error){
				},
				complete: function(xhr,status){
				},
			});
		}
	}
	//-----------------
	
	//Select Unique---
	function select_unique(selector, sibling_selector, conflict_callback){
		var value = $(selector).val();

		if(value != ""){
			$(sibling_selector).each(function(){
				var sibling_value = $(this).val();
				if(this != selector && sibling_value == value){
					if($(selector).hasClass("select2-offscreen")){
						$(selector).select2("val", "");
					}
					else{
						$(selector).val("");
					}

					if(conflict_callback != null) conflict_callback();
					
					return false;
				}
			});
		}
	}
	//----------------
	
	//Form Required---
	function form_required(form){
		var element = null;

		$(form).find("[required]:not(:disabled)").each(function(){
			if(! $(this).is(":radio")){
				if($(this).val() == "" || $(this).val() == null){
					element = this;
				}
			}
			else{
				var name = $(this).attr("name");
				if(name != undefined && name != ""){
					if($(form).find("[name='" + name + "']:checked").length == 0){
						element = this;
					}
				}
			}

			if(element != null) return false;
		});
		
		return element;
	}
	//----------------
	
	function call_exe(menu, show_loading, callback){
		if(show_loading == null) show_loading = false;
		
		if(show_loading) prompt_loading();
		
		var params = "";
		params += "&MENU=" + menu;
		params += "&USER_ID=<?php echo $this->session->userdata('user_id');?>";

		var site = "<?php echo base_url("api/call_exe");?>";
		site += "?" + params;

		$.getJSON(encodeURI(site), function(result){
			if(show_loading){
				if(result['PK'] != null){
					call_exe_is_complete(result['PK']);
				}
				else{
					dismiss_loading();
				}
			}
		})
		.done(function(){
		})
		.fail(function(){
		})
		.always(function(){
			if(callback != undefined) callback();
		});
	}
	
	function call_exe_is_complete(pk, count){
		(count == null)? count = 1:count++;
		
		var params = "";
		params += "&PK=" + pk;

		var site = "<?php echo base_url("api/call_exe_is_complete");?>";
		site += "?" + params;

		$.getJSON(encodeURI(site), function(result){
			if(result['COMPLETE']){
				dismiss_loading();
			}
			else{
				if(count < 5){
					setTimeout(function(){
						call_exe_is_complete(pk, count);
					}, 1000);
				}
				else{
					dismiss_loading();
				}
			}
		})
		.done(function(){
		})
		.fail(function(){
		})
		.always(function(){
		});
	}

	//Export to Excel---
	function export_excel(params){
		var data = {};
		data.FILENAME = params['FILENAME'] != null? params['FILENAME']:"Book1";
		data.CONTENT = {};
		data.MERGE = [];
		data.H_ALIGN = {};
		data.V_ALIGN = {};
		data.T_BORDER = {};
		data.B_BORDER = {};
		data.L_BORDER = {};
		data.R_BORDER = {};
		data.WIDTH = params['WIDTH'] != null? params['WIDTH']:{};
		data.FONT_SIZE = {};
		data.FONT_WEIGHT = {};

		target = params['TARGET'] != null? params['TARGET'].trim() + " ":"";

		//Calculate Total Column---
		var total_col = 0;
		$(target + ".report_table_content tr:not(.excel_bypass):first").find("th:not(.excel_bypass), td:not(.excel_bypass)").each(function(){
			if($(this).attr("colspan") == undefined){
				total_col++;
			}
			else{
				var colspan = to_int($(this).attr("colspan"));
				total_col += colspan >= 1? colspan:1;
			}
		});
		//-------------------------
		
		//Font Size---
		//	Header---
		$(target + ".report_header").each(function(x){
			var row = x + 1;
			var index = 'A' + row;
			data.FONT_SIZE[index] = parseFloat($(this).css("font-size"));
		});
		//	---------
		//------------
		
		//Font Weight---
		data.FONT_WEIGHT['A1'] = "BOLD";
		//--------------
		
		//Header---
		$(target + ".report_header").each(function(x){
			var row = x + 1;
			var index = 'A' + row;
			
			data.CONTENT[index] = $(this).html().trim();
			data.H_ALIGN[index] = "C";
			
			var from_col = "A";
			var to_col = from_col;
			for(var x=2; x<=total_col; x++){
				to_col = next_char(to_col);
			}
			
			data.MERGE.push(from_col + row + ":" + to_col + row);
		});
		//---------
		
		//Params---
		//	Left---
		var col = "A";
		var left_row = $(target + ".report_header").length + 1;
		var params_left_label = $(target + ".report_params_left_label").toArray();
		var params_left_data = $(target + ".report_params_left_data").toArray();

		for(var x=0; x<params_left_label.length; x++){
			data.CONTENT[col + left_row] = $(params_left_label[x]).html().trim() + " " + $(params_left_data[x]).html().trim();
			data.H_ALIGN[col + left_row] = "L";
			
//			var from_col = col;
//			var to_col = next_char(col);
//			data.MERGE.push(from_col + left_row + ":" + to_col + left_row);

			left_row++;
		}
		//	-------
		
		//	Right---
		var col = "A";
		for(var x=2; x<=total_col; x++){
			col = next_char(col);
		}
		var right_row = $(target + ".report_header").length + 1;
		var params_right_label = $(target + ".report_params_right_label").toArray();
		var params_right_data = $(target + ".report_params_right_data").toArray();

		for(var x=0; x<params_right_label.length; x++){
			data.CONTENT[col + right_row] = $(params_right_label[x]).html().trim() + " " + $(params_right_data[x]).html().trim();
			data.H_ALIGN[col + right_row] = "R";
			
//			var from_col = col;
//			var to_col = next_char(col);
//			data.MERGE.push(from_col + right_row + ":" + to_col + right_row);

			right_row++;
		}
		//	--------
		//---------
		
		//Content---
		var row = left_row > right_row? left_row:right_row;
		var tr_array = $(target + ".report_table_content").find("tr:not(.excel_bypass)");
		$(tr_array).each(function(x){
			var col = "A";
			var is_last_row = (x == (tr_array.length - 1));
			$(this).find("th:not(.excel_bypass), td:not(.excel_bypass)").each(function(){
				//Check if rowspan---
				var conflict;
				do{
					conflict = false;
					
					$(data.MERGE).each(function(y, value){
						var value_array = value.split(":");
						if(value_array.length == 2){
							var merge_cell_from = value_array[0];
							var merge_cell_from_col = merge_cell_from.replace(/[0-9]/g, '');
							var merge_cell_from_row = merge_cell_from.replace(/[^0-9]/g, '');
							var merge_cell_to = value_array[1];
							var merge_cell_to_col = merge_cell_to.replace(/[0-9]/g, '');
							var merge_cell_to_row = merge_cell_to.replace(/[^0-9]/g, '');

							if(merge_cell_from_col == merge_cell_to_col && merge_cell_from_col == col){
								if(row >= merge_cell_from_row && row <= merge_cell_to_row){
									col = next_char(col);
									conflict = true;
									return false;
								}
							}
						}
					});
				}
				while(conflict);
				//-------------------
				
				data.CONTENT[col + row] = $(this).html().trim();

				//Horizontal Align---
				if($(this).css("text-align") != undefined){
					var style = "";
					switch($(this).css("text-align")){
						case "center":
							style = "C";
							break;
						case "left":
							style = "L";
							break;
						case "right":
							style = "R";
							break;
					}
					if(style != "") data.H_ALIGN[col + row] = style;
				}
				//-------------------

				//Vertical Align---
				if($(this).css("vertical-align") != undefined){
					var style = "";
					switch($(this).css("vertical-align")){
						case "middle":
							style = "M";
							break;
						case "top":
						case "text-top":
							style = "T";
							break;
						case "bottom":
						case "text-bottom":
							style = "B";
							break;
					}
					if(style != "") data.V_ALIGN[col + row] = style;
				}
				//-----------------

				//Rowspan---
				var rowspan = ($(this).attr("rowspan") != undefined && to_int($(this).attr("rowspan")) > 1)? to_int($(this).attr("rowspan")):1;
				var from_row = row;
				var to_row = row + (rowspan - 1);
				if(rowspan > 1) data.MERGE.push(col + row + ":" + col + to_row);
				//----------

				//Colspan---
				var colspan = ($(this).attr("colspan") != undefined && to_int($(this).attr("colspan")) > 1)? to_int($(this).attr("colspan")):1;
				var from_col = col;
				var to_col = col;
				for(var x=1; x<=colspan; x++){
					if(x == colspan) to_col = col;
					col = next_char(col);
				}
				if(colspan > 1) data.MERGE.push(from_col + row + ":" + to_col + row);
				//----------

				if($(this).hasClass("R_border_top")){
					var index = colspan == 1? from_col + from_row:from_col + from_row + ":" + to_col + from_row;
					data.T_BORDER[index] = "THIN";
				}
				if($(this).hasClass("R_border_bottom")){
					var index = colspan == 1? to_col + to_row:from_col + to_row + ":" + to_col + to_row;
					data.B_BORDER[index] = "THIN";
				}
				if($(this).hasClass("R_border_left")){
					var index = rowspan == 1? from_col + from_row:from_col + from_row + ":" + from_col + to_row;
					data.L_BORDER[index] = "THIN";
				}
				if($(this).hasClass("R_border_right")){
					var index = rowspan == 1? to_col + to_row:to_col + from_row + ":" + to_col + to_row;
					data.R_BORDER[index] = "THIN";
				}
				if($(this).hasClass("R_border_double_top")){
					var index = colspan == 1? from_col + from_row:from_col + from_row + ":" + to_col + from_row;
					data.T_BORDER[index] = "DOUBLE";
				}
				if($(this).hasClass("R_border_double_bottom")){
					var index = colspan == 1? to_col + to_row:from_col + to_row + ":" + to_col + to_row;
					data.B_BORDER[index] = "DOUBLE";
				}
				if($(this).hasClass("R_border_double_left")){
					var index = rowspan == 1? from_col + from_row:from_col + from_row + ":" + from_col + to_row;
					data.L_BORDER[index] = "DOUBLE";
				}
				if($(this).hasClass("R_border_double_right")){
					var index = rowspan == 1? to_col + to_row:to_col + from_row + ":" + to_col + to_row;
					data.R_BORDER[index] = "DOUBLE";
				}
				if($(this).hasClass("R_border_thick_top")){
					var index = colspan == 1? from_col + from_row:from_col + from_row + ":" + to_col + from_row;
					data.T_BORDER[index] = "THICK";
				}
				if($(this).hasClass("R_border_thick_bottom")){
					var index = colspan == 1? to_col + to_row:from_col + to_row + ":" + to_col + to_row;
					data.B_BORDER[index] = "THICK";
				}
				if($(this).hasClass("R_border_thick_left")){
					var index = rowspan == 1? from_col + from_row:from_col + from_row + ":" + from_col + to_row;
					data.L_BORDER[index] = "THICK";
				}
				if($(this).hasClass("R_border_thick_right")){
					var index = rowspan == 1? to_col + to_row:to_col + from_row + ":" + to_col + to_row;
					data.R_BORDER[index] = "THICK";
				}

				if(is_last_row){
//					var index = colspan == 1? from_col + row:from_col + row + ":" + to_col + row;
//					data.T_BORDER[index] = "THIN";
				}
			});
			row++;
		});
		//----------
		
		if($("#form_excel").length == 0){
			var form_content = "<form id='form_excel' action='<?php echo base_url("export_excel");?>' method='POST' style='display: none;'></form>";

			$("body:first").append(form_content);
		}
		
		var content = "";
		content += "<input type='hidden' name='DATA'>";

		$("#form_excel").html(content);
		$("#form_excel [name='DATA']").val(JSON.stringify(data));
		$("#form_excel").submit();
	}
	//------------------
	
	//Input Assist---
	var input_assist_element;
	var input_assist_capslock = false;
	var input_assist_mask = false;
	var input_assist_indicator_max_length;
	var input_assist_action_after_confirm;
	
	$(document).ready(function(){
		if($("#cb_input_assist").length > 0){
			$("#cb_input_assist").bootstrapSwitch({
				onColor: "primary",
				offColor: "danger",
				onText: "ON",
				offText: "OFF",
				size: "mini",
				labelWidth: 1,
				onSwitchChange:function(){
					if($(this).is(":checked")){
						localStorage.<?php echo $ci->config->item('project');?>_input_assist = "1";
					}
					else{
						localStorage.<?php echo $ci->config->item('project');?>_input_assist = "0";
					}
				},
			});
		}
	
		if(localStorage.<?php echo $ci->config->item('project');?>_input_assist == null) localStorage.<?php echo $ci->config->item('project');?>_input_assist = "0";
	
		if(localStorage.<?php echo $ci->config->item('project');?>_input_assist == "1"){
			$("#cb_input_assist").bootstrapSwitch("toggleState", true);
		}
	
		$("#input_assist_number_modal").on("hidden.bs.modal",function (){
			input_assist_reset();
		})
	});
	
	function input_assist(element, mode, compulsory, action_after_confirm){
		//Mode:
		//1 = Number and Character
		//2 = Number and Character (Password Mask)
		//3 = Number only
		//4 = Character only
		//5 = Number and Character with Special Chars
		//6 = Number with Special Chars
		//7 = Number with Special Chars (Positive Only)
		if(mode == undefined) mode = 1;
		if(compulsory == undefined) compulsory = false;
		input_assist_action_after_confirm = action_after_confirm != undefined? action_after_confirm:null;
		
		if(localStorage.<?php echo $ci->config->item('project');?>_input_assist == "1" || compulsory){
			input_assist_element = element;
	
			input_assist_reset();
			
			switch(mode){
				case 1:
					$("#input_assist_modal_dialog").addClass("modal-lg");
					$("#input_assist_keyboard_1").show();
	
					input_assist_indicator_max_length = 25;
					break;
				case 2:
					$("#input_assist_modal_dialog").addClass("modal-lg");
					$("#input_assist_keyboard_1").show();
	
					input_assist_indicator_max_length = 25;
					input_assist_mask = true;
					break;
				case 3:
					$("#input_assist_keyboard_2").show();
	
					input_assist_indicator_max_length = 15;
					break;
				case 4:
					$("#input_assist_modal_dialog").addClass("modal-lg");
	
					input_assist_indicator_max_length = 25;
					break;
				case 5:
					$("#input_assist_modal_dialog").addClass("modal-lg");
					$("#input_assist_keyboard_1").show();
					$(".input_assist_keyboard_special_chars").show();
	
					input_assist_indicator_max_length = 25;
					break;
				case 6:
					$("#input_assist_keyboard_2").show();
					$(".input_assist_keyboard_special_chars").show();
	
					input_assist_indicator_max_length = 15;
					break;
				case 7:
					$("#input_assist_keyboard_2").show();
					$(".input_assist_keyboard_special_chars").show();
	
					disable_btn(".input_assist_btn_sign");
	
					input_assist_indicator_max_length = 15;
					break;
			}
	
			var existing_value = $(element).val();
			$("#input_assist_input").val(existing_value);
	
			var string = "";
			if(! input_assist_mask){
				string = existing_value;
			}
			else{
				for(var x=1; x<=existing_value.length; x++){
					string += "*";
				}
			}
			if(string.length > input_assist_indicator_max_length) string = ".." + string.substr(string.length - input_assist_indicator_max_length);
			string = string.replace(/ /g, "&nbsp;");
			$("#input_assist_indicator").html(string);
			
			
			$("#input_assist_number_modal").modal("show");
		}
	}
	
	function input_assist_reset(){
		$("#input_assist_input").val("");
		$("#input_assist_indicator").html("");
	
		if(input_assist_capslock) input_assist_insert("SHIFT");
		
		$("#input_assist_modal_dialog").removeClass("modal-lg");
	
		$("#input_assist_keyboard_1").hide();
		$("#input_assist_keyboard_2").hide();
		$(".input_assist_keyboard_special_chars").hide();
	
		enable_btn(".input_assist_btn_sign");
	
		input_assist_mask = false;
	}
	
	function input_assist_insert(input){
		if(input.length > 1){
			switch(input){
				case "BS":
					var input_value = $("#input_assist_input").val();
					if(input_value != ""){
						input_value = input_value.substr(0, input_value.length - 1);
						$("#input_assist_input").val(input_value);
	
						var string = "";
						if(! input_assist_mask){
							string = input_value;
						}
						else{
							for(var x=1; x<=input_value.length; x++){
								string += "*";
							}
						}
						if(string.length > input_assist_indicator_max_length) string = ".." + string.substr(string.length - input_assist_indicator_max_length);
						string = string.replace(/ /g, "&nbsp;");
						$("#input_assist_indicator").html(string);
					}
					break;
				case "CLEAR":
					$("#input_assist_input").val("");
					$("#input_assist_indicator").html("");
					break;
				case "SHIFT":
					input_assist_capslock = ! input_assist_capslock;
	
					if(input_assist_capslock){
						$(".btn_capslock").addClass("btn-primary");
						$(".btn_capslock").removeClass("btn-default");
					}
					else{
						$(".btn_capslock").removeClass("btn-primary");
						$(".btn_capslock").addClass("btn-default");
					}
					break;
				case "DOT":
					var input_value = $("#input_assist_input").val();
					if(input_value.indexOf(".") == "-1"){
						input_value += ".";
						$("#input_assist_input").val(input_value);
	
						var string = "";
						if(! input_assist_mask){
							string = input_value;
						}
						else{
							for(var x=1; x<=input_value.length; x++){
								string += "*";
							}
						}
						if(string.length > input_assist_indicator_max_length) string = ".." + string.substr(string.length - input_assist_indicator_max_length);
						//string = string.replace(/ /g, "&nbsp;");
						$("#input_assist_indicator").html(string);
					}
					break;
				case "POSITIVE":
					var input_value = $("#input_assist_input").val();
					if(input_value != ""){
						if(parseFloat(input_value) < 0) input_value *= -1;
						$("#input_assist_input").val(input_value);
	
						var string = "";
						if(! input_assist_mask){
							string = input_value;
						}
						else{
							for(var x=1; x<=input_value.length; x++){
								string += "*";
							}
						}
						if(string.length > input_assist_indicator_max_length) string = ".." + string.substr(string.length - input_assist_indicator_max_length);
						//string = string.replace(/ /g, "&nbsp;");
						$("#input_assist_indicator").html(string);
					}
					break;
				case "NEGATIVE":
					var input_value = $("#input_assist_input").val();
					if(input_value != ""){
						if(parseFloat(input_value) >= 0) input_value *= -1;
						$("#input_assist_input").val(input_value);
	
						var string = "";
						if(! input_assist_mask){
							string = input_value;
						}
						else{
							for(var x=1; x<=input_value.length; x++){
								string += "*";
							}
						}
						if(string.length > input_assist_indicator_max_length) string = ".." + string.substr(string.length - input_assist_indicator_max_length);
						//string = string.replace(/ /g, "&nbsp;");
						$("#input_assist_indicator").html(string);
					}
					break;
			}
		}
		else{
			var input_value = $("#input_assist_input").val();
			var max_length = $(input_assist_element).attr("maxlength");
			if(max_length == undefined || (input_value.length + 1) <= max_length){
				input_value += input_assist_capslock? input.toString():input.toString().toLowerCase();
				$("#input_assist_input").val(input_value);
	
				var string = "";
				if(! input_assist_mask){
					string = input_value;
				}
				else{
					for(var x=1; x<=input_value.length; x++){
						string += "*";
					}
				}
				if(string.length > input_assist_indicator_max_length) string = ".." + string.substr(string.length - input_assist_indicator_max_length);
				string = string.replace(/ /g, "&nbsp;");
				$("#input_assist_indicator").html(string);
			}
		}
		
		$(":focus").blur();
	}
	
	function input_assist_confirm(){
		var value = $("#input_assist_input").val();
		$(input_assist_element).val(value);
	
		$(input_assist_element).keydown().keyup().trigger("input");
	}
	//---------------
</script>