<?php $ci = get_instance();?>
<!DOCTYPE html>
<html lang="en">
<head>
	<?php $this->load->view("includes/header");?>
</head>

<body>
	<?php $this->load->view("includes/menu");?>
	
	<section class="content">
		<?php $this->load->view("includes/nav");?>
		
		<div class="wraper container-fluid xs_container-fluid">
<!--			<div class="page-title"> -->
<!--				<h3 class="title">Panels</h3> -->
<!--			</div>-->
			
			<div class="row">
				<div class="col-md-offset-1 col-md-10">
					<?php $this->load->view("includes/success_msg");?>
					
					<div class="panel panel-default xs_panel" style="padding-left: 10px; padding-right: 10px;">
						<div class="panel-heading">
							<center>
								<h3 class="panel-title">
									<i class="fa fa-user-o fa-fw"></i>
									Staff
								</h3> 
							</center>
							<div class="pull-left" style="margin-top: -20px;">
								<?php 
									$has_filter = FALSE;
									foreach($_GET as $index=>$g){
										if(! in_array($index, array("PAGE", "S", "SD", "PP")) && $g != ""){
											$has_filter = TRUE;
											break;
										}
									}
								?>
								<!--  -->
								<a href="#search_modal" data-toggle="modal" class="visible-xs <?php echo $has_filter? "text-danger":"";?>" style="margin-left: 10px;">
									<i class="fa fa-search fa-lg"></i>
								</a>
								<a href="#search_modal" data-toggle="modal" class="hidden-xs btn <?php echo $has_filter? "btn-danger":"btn-primary";?> btn-xs">
									<i class="fa fa-search"></i>
									Search
								</a>
								<a href="javascript:;" onclick="print_document();" class="hidden-xs btn <?php echo $has_filter? "btn-danger":"btn-primary";?> btn-xs">
								   <i class="fa fa-print"></i>
								    Print
								</a>
								<!--  -->
							</div>
							<div class="pull-right" style="margin-top: -20px;">
								<!--  -->
								<div id="div_btn_new" style="display: none;">
									<a href="<?php echo base_url($this->router->fetch_class()."/edit");?>" class="visible-xs" style="margin-right: 10px; color: #797979;">
										<i class="fa fa-plus-circle fa-lg"></i>
									</a>
									<a href="<?php echo base_url($this->router->fetch_class()."/edit");?>" class="hidden-xs btn btn-primary btn-xs">
										<i class="fa fa-plus-circle"></i> New
									</a>
								</div>
								<!--  -->
							</div>
						</div>
						<div class="panel-body">
							<div id="ajax_container"><!-- AJAX --></div>
						</div>
					</div>
				</div>
			</div>
		</div>
	
		<!-- search_modal -->
		<div id="search_modal" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
			<div class="modal-dialog">
				<div class="modal-content">
					<form id="filter_form" action="#" method="GET">
						<!-- -->
						<input type="hidden" name="PAGE" value="<?php echo (int)$this->input->get('PAGE') != 0? (int)$this->input->get('PAGE'):"1";?>">
						<input type="hidden" name="S" value="<?php echo $this->input->get('S');?>">
						<input type="hidden" name="SD" value="<?php echo (int)$this->input->get('SD');?>">
						<input type="hidden" name="PP">
						<!-- -->
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
							<h4 class="modal-title">Search</h4>
						</div>
						<div class="modal-body">
							<div class="form-group">
								<label>Code</label>
								<input type="text" name="CODE" value="<?php echo $ci->fm->str_esc($this->input->get('CODE'), 2);?>" class="form-control">
							</div>
						</div>
						<div class="modal-footer">
							<a href="<?php echo base_url($this->router->fetch_class());?>" class="btn btn-default">Reset</a>
							<button type="submit" onClick="$('#PAGE').val('1');" class="btn btn-primary">
								<i class="fa fa-search"></i>
								Search
							</button>
						</div>
					</form>
				</div>
			</div>
		</div>
		<!--  -->
		<div id="div_print" style="display: none;"></div>
		<?php $this->load->view("includes/footer");?>
	</section>
	
	<script type="text/javascript">
		$(document).ready(function(){
			$(".select2").select2();

			json_resource(function(){
				load_data();
			});
		});

		//Global Variables---
		var timer_check_unique;
		var checking_unique;
		//-------------------

		function json_resource(callback){
			$(".resource_loader").show("fast");

			var params = "";
			params += "&t[]=GROUP";
			params += "&s[]=<T>.NAME";
			
			var site = "<?php echo base_url("api/get_resource");?>";
			site += "?" + params;

			$.getJSON(encodeURI(site), function(result){
				if(result != ""){
					//GROUP---
					<?php $field = "GROUP[]";?>
					var selector = "#filter_form [name='<?php echo $field;?>']";
					var string = "";
					$(result.GROUP).each(function(index, value){
						string += "<option value='" + value.PRIMARY + "'>" + value.NAME + "</option>";
					});
					$(selector).html(string);

					var value = [];
					<?php if(is_array($this->input->get(str_replace("[]", "", $field)))):?>
						<?php foreach($this->input->get(str_replace("[]", "", $field)) as $v):?>
							value.push("<?php echo $v;?>");
						<?php endforeach;?>
					<?php endif;?>
					$(selector).select2("val", value);
					//--------
				}
			})
			.done(function(){
			})
			.fail(function(){
			})
			.always(function(){
				$(".resource_loader").hide("fast");
				if(callback != undefined) callback();
			});
		}

		function print_document(mode){
			if(mode == null) mode = "PRINT";
			var fontsize = "14";
			
			var params = "";
			params += "&print=1";

			$("#filter_form [name]").each(function(){
				var name = $(this).attr("name");
				var value = $(this).val();
				
				if($(this).is(":checkbox")){
					if($(this).is(":checked")) params += "&" + name + "=" + value;
				}
				else{
					if($.isArray(value)){
						$(value).each(function(x, v){
							if(v != null){
								params += "&" + name + "=" + v;
							}
						});
					}
					else{
						if(value != null){
							params += "&" + name + "=" + value;
						}
					}
				}
			});

			$.ajax({
				type: "POST",
				url: "<?php echo base_url($this->router->fetch_class()."/load_data?".$_SERVER['QUERY_STRING']);?>",
				data: params,
				success: function(result, status, xhr){
					$("#div_print").html(result);

					switch(mode){
						case "PRINT":
							browser_print("#div_print");
							break;
					}
				},
				error: function(xhr,status,error){
					prompt_error("<?php echo $this->text_ajax_fail;?>");
				},
				complete: function(xhr,status){
					dismiss_loading();
				},
			});
			
		}

		function load_data(callback){
			//Loader---
			$("#ajax_container").html("<?php echo $this->text_ajax_loader;?>");
			//---------
			
			<?php if($this->input->get('PP') != ""):?>
				$("#filter_form [name='PP']").val("<?php echo $this->input->get('PP');?>");
			<?php else:?>
				var per_page = localStorage.<?php echo $ci->config->item('project');?>_per_page != null? localStorage.<?php echo $ci->config->item('project');?>_per_page:<?php echo $ci->per_page_array[0];?>;
				$("#filter_form [name='PP']").val(per_page);
			<?php endif;?>
			
			var params = "";
			$("#filter_form [name]").each(function(){
				var name = $(this).attr("name");
				var value = $(this).val();
				
				if($(this).is(":checkbox")){
					if($(this).is(":checked")) params += "&" + name + "=" + value;
				}
				else{
					if($.isArray(value)){
						$(value).each(function(x, v){
							if(v != null){
								params += "&" + name + "=" + v;
							}
						});
					}
					else{
						if(value != null){
							params += "&" + name + "=" + value;
						}
					}
				}
			});

			$.ajax({
				type: "POST",
				url: "<?php echo base_url($this->router->fetch_class()."/load_data?".$_SERVER['QUERY_STRING']);?>",
				data: params,
				success: function(result, status, xhr){
					$("#ajax_container").html(result);
				},
				error: function(xhr,status,error){
					$("#ajax_container").html("<?php echo $this->text_ajax_fail;?>");
				},
				complete: function(xhr,status){
					if(callback != undefined) callback();
				},
			});
		}
	</script>
</body>
</html>
