<?php $ci = get_instance();?>

<table class="visible-xs table table-bordered">
	<?php if(count($list) > 0):?>
		<?php foreach($list as $lv):?>
            <tr data-id="<?php echo $lv->REFNO;?>" class="xs_tr_data" style="cursor: pointer;">
				<td style="vertical-align: middle; padding: 5px;">
					<table class="FG_table" style="margin: 0;">
                        <tr>
                            <th class="FG_th" style="padding: 5px;">REFNO:</th>
                            <td class="FG_td" style="padding: 5px;">
                                <?php echo $lv->REFNO;?>
                            </td>
                        </tr>
				</table>
				</td>
			</tr>
		<?php endforeach;?>
	<?php else:?>
		<tr>
			<td style="text-align: center; padding-top: 25px; padding-bottom: 25px;">No result.</td>
		</tr>
	<?php endif;?>
</table>
<div>
<table class="table table-striped table-bordered table-sm" style="width: 99%;">
	<thead>
		<tr>
			<?php echo $ci->fm->generate_table_header($header_array);?>
		</tr>
	</thead>
	<tbody>
		<?php if(count($list) > 0):?>
			<?php $n = ($config['page'] * $config['per_page']) + 1;?>
			<?php foreach($list as $lv):?>
				<tr>
					<td style="text-align: center;"><?php echo $n;?></td>                               
					<td style="text-align: center;"><?php echo $lv->REFNO;?></td>
					<td style="text-align: center;"><?php echo date("Y-m-d", strtotime($lv->DATE));?></td>
					<td style="text-align: center;"><?php echo $lv->DEBTOR_NAME;?></td>
					<td style="text-align: center;"><?php echo $lv->TTNAME;?></td>
					<td style="text-align: center;"><?php echo $lv->STAFF_NAME;?></td>
					<td style="text-align: center;"><?php echo $lv->TRADEIN_W;?></td>
					<td style="text-align: center;"><?php echo $lv->BAL;?></td>
					<td style="text-align: center; white-space: nowrap;">
						<div class="btn-group">
							<?php 
								$btn_array = array();
								array_push($btn_array, array(
                                    'href' => base_url($this->router->fetch_class()."/edit/".$lv->REFNO),
									'icon' => "fa fa-fw ".($can_edit? "fa-edit":"fa-search"),
									'description' => $can_edit? "Edit":"View",
								));

								array_push($btn_array, array(
										'href' => "javascript:;",
										'onClick' => "print_document('".$lv->REFNO."');",
										'icon' => "fa fa-fw fa-print",
										'description' => "Print Invoice",
									));
								
								echo $ci->fm->generate_btn($btn_array);
							?>
						</div>
					</td>
				</tr>
				<?php $n++;?>
			<?php endforeach;?>
		<?php else:?>
			<tr>
				<td colspan="99">
					<center>
						No result.
					</center>
				</td>
			</tr>
		<?php endif;?>
	</tbody>
</table>
<a href="javascript:" id="return-to-top"><i class="fa fa-arrow-up"></i></a>
<div id="div_print" style="display: none;"></div>
<?php echo $ci->load->view("includes/pagination", array('config' => $config, 'count' => $count));?>
<?php echo $ci->load->view("includes/per_page");?>

<script>
	$(document).ready(function(){
		<?php if($can_create):?>
			$("#div_btn_new").show("fast");
		<?php endif;?>
		
		$(".xs_tr_data").click(function(){
			var id = $(this).attr("data-id");
			window.location.assign("<?php echo base_url($this->router->fetch_class()."/edit/");?>/" + id);
		});
	});

	$(window).scroll(function() {
    if ($(this).scrollTop() >= 50) {        // If page is scrolled more than 50px
        $('#return-to-top').fadeIn(200);    // Fade in the arrow
    } else {
        $('#return-to-top').fadeOut(200);   // Else fade out the arrow
    }
    });
    $('#return-to-top').click(function() {      // When arrow is clicked
        $('body,html').animate({
            scrollTop : 0                       // Scroll to top of body
        }, 500);
    });

	function print_document(id){
		var css = '@page { size: a4 portrait; } .R_table{font-family: arial;}';
		$.ajax({
			type: "POST",
			url: "<?php echo base_url($this->router->fetch_class());?>/load_print",
			data: "REFNO=" + id,
			success: function(result, status, xhr){
				$("#div_print").html(result);

				browser_print(result,css,'');
				
			},
			error: function(xhr,status,error){
				$("#div_print").html("<?php echo $this->text_ajax_fail;?>");
			},
			complete: function(xhr,status){
			},
		});
		
	}
</script>
